<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteNewByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method getStoresForPurchaseByParams(array $params)
 */
class PurchaseGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建集采
     *
     * @param  string $storeType 门店类型 [ require true ]
     * @param  array $storeIds 门店id数组 [ require true ]
     * @param  array $skuInfo 物料sku数组 [ require true ]
     * @param  string $purchaseType 采购类型 [ require true ]
     * @param  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $storeType = '', array $skuInfo, array $storeIds = [], string $purchaseType = 'group', int $storageId = 0) {
        return self::getClass()->create([
            "storeType" => $storeType,
            "skuInfo" => $skuInfo,
            "storeIds" => $storeIds,
            "purchaseType" => $purchaseType,
            "storageId" => $storageId,
        ]);
    }

    /**
     * 集采列表[分页]
     *
     * @support  string $startAt start_at require false
     * @support  string $endAt end_at require false
     * @support  int $createBy 下单人工号 require false
     * @support  string $status 状态 require false
     * @support  string $type 集采类型:normal/excel require false
     * @support  string $purchaseType 采购类型 require false
     * @support  string $demandNo 需求单号 require false
     * @param  int $page page [ require true ]
     * @param  int $pageSize pageSize [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 集采详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除新建状态的集采
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteNew (int $id) {
        return self::getClass()->deleteNew([
            "id" => $id,
        ]);
    }

    /**
     * 批量集采
     *
     * @param  array $purchaseInfo 采购信息 [ require true ]
     * @param  string $remark 采购备注 [ require true ]
     * @param  string $purchaseType 采购类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreate (array $purchaseInfo, string $purchaseType, string $remark = '') {
        return self::getClass()->batchCreate([
            "purchaseInfo" => $purchaseInfo,
            "purchaseType" => $purchaseType,
            "remark" => $remark,
        ]);
    }

    /**
     * getStoresForPurchase
     *
     * @support  string $storeType 门店类型 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStoresForPurchase () {
        return self::getClass()->getStoresForPurchase();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}