<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method importTemplateByParams(array $params)
 * @method importByParams(array $params)
 * @method importTrackingNumberByParams(array $params)
 * @method batchFullCloseByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemLogByParams(array $params)
 */
class PurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $noticeNo 发货通知单号 require false
     * @support  string $orderNo 采购单号 require false
     * @support  string $createdAtStart 创建开始时间 require false
     * @support  string $createdAtEnd 创建结束时间 require false
     * @support  int $createBy 创建人工号 require false
     * @support  int $fromStorageId 发货方id require false
     * @support  array $status 状态 require false
     * @support  string $demandNo 需求单号 require false
     * @support  array $materialIds 物料id require false
     * @support  string $receiveNo 收货通知单号 require false
     * @support  int $toStorageId 收货方id require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $noticeId 发货通知单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $noticeId) {
        return self::getClass()->detail([
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $noticeId 发货通知单id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $noticeId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "noticeId" => $noticeId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 发货通知单导入模板
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTemplate (array $noticeIds) {
        return self::getClass()->importTemplate([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 导入快递单号和数量
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function import (array $data) {
        return self::getClass()->import([
            "data" => $data,
        ]);
    }

    /**
     * 导入快递单号
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function importTrackingNumber (array $data) {
        return self::getClass()->importTrackingNumber([
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭发货主单
     *
     * @param  array $noticeIds 关闭的发货单IDs [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchFullClose (array $noticeIds) {
        return self::getClass()->batchFullClose([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 批量发运
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSend (array $noticeIds) {
        return self::getClass()->batchSend([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  array $data 待修改的信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  array $data 待关闭的信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchClose (array $data) {
        return self::getClass()->batchClose([
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [ require true ]
     * @support  string $action 操作类型 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getItemLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}