<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTaxesByParams(array $params)
 * @method syncTaxByParams(array $params)
 */
class Tax {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取税码
     *
     * @param  string $desc 描述 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTaxes (string $desc = '') {
        return self::getClass()->getTaxes([
            "desc" => $desc,
        ]);
    }

    /**
     * 同步税码信息
     *
     * @param  string $desc 名称 [ require true ]
     * @param  float $rate 税率 [ require true ]
     * @param  int $nsId ns的id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncTax (string $desc, int $nsId = 0, float $rate = 0.0) {
        return self::getClass()->syncTax([
            "desc" => $desc,
            "nsId" => $nsId,
            "rate" => $rate,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Tax');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Tax');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}