<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCategoriesByParams(array $params)
 * @method syncCategoryByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分类s
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $source 来源1自用2零售 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategories (string $name = '', int $source = 1) {
        return self::getClass()->getCategories([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * 同步品类信息
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @param  int $parentId 父级id [ require true ]
     * @param  int $level 级别 [ require true ]
     * @param  int $source 来源1自用2零售 [ require true ]
     * @param  int $nsId ns的id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncCategory (string $name, string $code, int $parentId, int $level, int $source = 1, int $nsId = 0) {
        return self::getClass()->syncCategory([
            "name" => $name,
            "code" => $code,
            "parentId" => $parentId,
            "level" => $level,
            "source" => $source,
            "nsId" => $nsId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}