<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method handleByParams(array $params)
 * @method confirmByParams(array $params)
 * @method stateByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class RetailReceiveException {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 异常列表
     *
     * @support  int $fromStorageId 发货仓库id require false
     * @support  int $toStorageId 收货仓库id require false
     * @support  string $receiveNo 收货单号 require false
     * @support  int $status 状态 1提交，2处理完成 require false
     * @support  int $handler 异常处理人:1是发货方,2是总部 [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 处理异常
     *
     * @support  int $receiveItemId 发货单明细id [ require true ]
     * @support  int $skuId skuId [ require true ]
     * @support  int $errorNumByFrom 计入发货方库存 [ require true ]
     * @support  int $errorNumByTo 计入收货方库存 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handle () {
        return self::getClass()->handle();
    }

    /**
     * 确认异常
     *
     * @support  int $receiveItemId 发货单明细id [ require true ]
     * @support  int $skuId skuId [ require true ]
     * @support  int $errorNum 异常处理数量 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function confirm () {
        return self::getClass()->confirm();
    }

    /**
     * 异常申述（处理人变更）
     *
     * @param  int $id 异常id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function state (int $id) {
        return self::getClass()->state([
            "id" => $id,
        ]);
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailReceiveException');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailReceiveException');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}