<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method redPointByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method supplySystemItemListByParams(array $params)
 * @method supplySystemItemListHistoryByParams(array $params)
 */
class Supplier {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 供应商协同-红点查看获取已逾期+加急的 发货单据数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function redPoint () {
        return self::getClass()->redPoint();
    }

    /**
     * 批量发运
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSend (array $noticeIds) {
        return self::getClass()->batchSend([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 供应商协同-采购发货单-列表
     *
     * @support  string $planDateStart 预计发货时间Start [ require false ]
     * @support  string $planDateEnd 预计发货时间End [ require false ]
     * @support  string $planLatestDateStart 最晚发货时间Start [ require false ]
     * @support  string $planLatestDateEnd 最晚发货时间End [ require false ]
     * @support  string $status 发货状态 [ require false ]
     * @support  int $skuId 物料id [ require false ]
     * @support  int $toStorageId 收货方 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplySystemItemList () {
        return self::getClass()->supplySystemItemList([
        ]);
    }

    /**
     * 供应商协同-采购发货单-历史列表
     *
     * @support  string $planDateStart 预计发货时间Start [ require false ]
     * @support  string $planDateEnd 预计发货时间End [ require false ]
     * @support  string $planLatestDateStart 最晚发货时间Start [ require false ]
     * @support  string $planLatestDateEnd 最晚发货时间End [ require false ]
     * @support  string $status 发货状态 [ require false ]
     * @support  int $skuId 物料id [ require false ]
     * @support  int $toStorageId 收货方 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplySystemItemListHistory () {
        return self::getClass()->supplySystemItemListHistory([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier\Supplier');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier\Supplier');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}