<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllocationListPageByParams(array $params)
 */
class SupplerAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 协同平台调拨单
     *
     * @support  array $statusMap 状态 [ require false ]
     * @support  int $skuId 物料id [ require false ]
     * @support  array $toStorageIds 收货方 [ require false ]
     * @support  string $planShipDateAtStart 预计发货时间 起 [ require false ]
     * @support  string $planShipDateAtEnd 预计发货时间 起 [ require false ]
     * @support  string $planLatestShipDateAtStart 最晚发货时间 起 [ require false ]
     * @support  string $planLatestShipDateAtEnd 最晚发货时间 终 [ require false ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllocationListPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAllocationListPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier\SupplerAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier\SupplerAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}