<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method geetestRegisterByParams(array $params)
 * @method geeTestValidateByParams(array $params)
 * @method accountLoginByParams(array $params)
 */
class SupplierAccount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * geetestRegister
     *
     * @support  string $clientType 名称/web [ require true ]
     * @support  string $ip 名称/web [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function geetestRegister () {
        return self::getClass()->geetestRegister([
        ]);
    }

    /**
     * 二次验证
     *
     * @support  string $geeTestChallenge 流水号，一次完整验证流程的唯一标识 [ require true ]
     * @support  string $geeTestValidate validate [ require false ]
     * @support  string $geeTestSecCode 核心校验数据 [ require false ]
     * @support  string $phone 用户手机号 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function geeTestValidate () {
        return self::getClass()->geeTestValidate([
        ]);
    }

    /**
     * 校验登录
     *
     * @support  string $code 验证码 [ require true ]
     * @support  string $phone 用户手机号 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function accountLogin () {
        return self::getClass()->accountLogin([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier\SupplierAccount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier\SupplierAccount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}