<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListPageByParams(array $params)
 * @method getAccountListByParams(array $params)
 * @method createAccountByParams(array $params)
 * @method editSupplierInfoByParams(array $params)
 * @method delAccountByParams(array $params)
 * @method getAllSuppliersByParams(array $params)
 * @method getSuppliersByParams(array $params)
 * @method syncSupplierByParams(array $params)
 * @method getBuyerSuppliersByParams(array $params)
 */
class Supplier {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取供应商分页列表
     *
     * @support  int $id 供应商id [ require false ]
     * @support  int $status 是否开启协同 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListPage (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getListPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取供应商 下的全部协同平台账号
     *
     * @param  int $supplierId 供应商id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAccountList (int $supplierId) {
        return self::getClass()->getAccountList([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 创建供应商账号
     *
     * @support  int $supplierId 供应商id [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $nickName 昵称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAccount () {
        return self::getClass()->createAccount([
        ]);
    }

    /**
     * 修改供应商协同开启状态
     *
     * @support  int $supplierId 供应商id [ require true ]
     * @support  int $status 是否开启协同 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editSupplierInfo () {
        return self::getClass()->editSupplierInfo([
        ]);
    }

    /**
     * 删除协同平台账号
     *
     * @support  int $id 协同平台账号id [ require true ]
     * @support  string $phone 协同平台账号手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delAccount () {
        return self::getClass()->delAccount([
        ]);
    }

    /**
     * 获取所有供应商
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSuppliers () {
        return self::getClass()->getAllSuppliers();
    }

    /**
     * 获取供应商s
     *
     * @param  string $name 名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuppliers (string $name = '') {
        return self::getClass()->getSuppliers([
            "name" => $name,
        ]);
    }

    /**
     * 同步供应商信息
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $nsId ns的id [ require false ]
     * @param  float $prepaidRate ns的id [ require false ]
     * @param  array $extend 额外信息 [ require false ]
     * @param  array $details 银行信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncSupplier (string $name, int $nsId = 0, float $prepaidRate = 0.0, array $extend = [], array $details = []) {
        return self::getClass()->syncSupplier([
            "name" => $name,
            "nsId" => $nsId,
            "prepaidRate" => $prepaidRate,
            "extend" => $extend,
            "details" => $details,
        ]);
    }

    /**
     * 通过采购用户id获取供应商id列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBuyerSuppliers () {
        return self::getClass()->getBuyerSuppliers();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}