<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getDeptStaffListByParams(array $params)
 * @method getAllStaffsByParams(array $params)
 * @method getAllStaffsByIdByParams(array $params)
 * @method removeAllStaffsCacheByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据门店id获取员工列表
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $storeId) {
        return self::getClass()->list([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 根据部门id获取员工列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getDeptStaffList () {
        return self::getClass()->getDeptStaffList();
    }

    /**
     * 获取所有员工
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStaffs () {
        return self::getClass()->getAllStaffs();
    }

    /**
     * 通过id获取伙伴信息
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStaffsById (int $staffId) {
        return self::getClass()->getAllStaffsById([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 删除重建staff缓存
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function removeAllStaffsCache () {
        return self::getClass()->removeAllStaffsCache();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}