<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method closeByParams(array $params)
 * @method revokeByParams(array $params)
 * @method submitByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method newGetCreateByInfosByParams(array $params)
 * @method getLogByParams(array $params)
 */
class PurchaseAdvance {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建预付款单
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $orderId) {
        return self::getClass()->create([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $advanceNo 预付款单号 [ require false ]
     * @support  string $orderNo 采购单号 [ require false ]
     * @support  string $createdAtStart 创建开始时间 [ require false ]
     * @support  string $createdAtEnd 创建结束时间 [ require false ]
     * @support  int $createBy 创建人工号 [ require false ]
     * @support  string $approveStatus 审批状态 [ require false ]
     * @support  string $status 付款状态 [ require false ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  string $demandNo 需求单号 [ require false ]
     * @support  string $dueNo 应付款单号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $advanceId 预付款单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $advanceId) {
        return self::getClass()->detail([
            "advanceId" => $advanceId,
        ]);
    }

    /**
     * 更新
     *
     * @support  int $advanceId 预付款单id [ require true ]
     * @support  int $supplierBankId 供应商账户id [ require false ]
     * @support  float $prepaidRate 预付比例 [ require false ]
     * @support  float $freight 运费 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $advanceId 预付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $advanceId) {
        return self::getClass()->close([
            "advanceId" => $advanceId,
        ]);
    }

    /**
     * 撤销审批
     *
     * @param  int $advanceId 预付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revoke (int $advanceId) {
        return self::getClass()->revoke([
            "advanceId" => $advanceId,
        ]);
    }

    /**
     * 提交审批
     *
     * @param  int $advanceId 预付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $advanceId) {
        return self::getClass()->submit([
            "advanceId" => $advanceId,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 新获取创建人s
     *
     * @param  string $nameOrNickname 用户名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function newGetCreateByInfos (string $nameOrNickname) {
        return self::getClass()->newGetCreateByInfos([
            "nameOrNickname" => $nameOrNickname,
        ]);
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [ require true ]
     * @support  string $action 操作类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseAdvance');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseAdvance');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}