<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllocationListPageByParams(array $params)
 * @method leftRemindByParams(array $params)
 * @method getSupplyAllocationListTagCountByParams(array $params)
 * @method supplyAllocationShipByParams(array $params)
 */
class SupplerAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 协同平台调拨单
     *
     * @support  array $skuIds 物料id [ require false ]
     * @support  int $type 列表类型 [ require true ]
     * @support  array $toStorageIds 收货方 [ require false ]
     * @support  string $planShipDateAtStart 预计发货时间 起 [ require false ]
     * @support  string $planShipDateAtEnd 预计发货时间 终 [ require false ]
     * @support  string $planLatestShipDateAtStart 最晚发货时间 起 [ require false ]
     * @support  string $planLatestShipDateAtEnd 最晚发货时间 终 [ require false ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @support  string $status 发货状态 [ require false ]
     * @support  int $expedited 是否加急 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllocationListPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAllocationListPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 供应商协同-侧边栏提示
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function leftRemind () {
        return self::getClass()->leftRemind();
    }

    /**
     * 供应商协同-列表标签
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplyAllocationListTagCount () {
        return self::getClass()->getSupplyAllocationListTagCount();
    }

    /**
     * 供应商调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplyAllocationShip () {
        return self::getClass()->supplyAllocationShip([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier\SupplerAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier\SupplerAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}