<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateByParams(array $params)
 * @method submitByParams(array $params)
 * @method closeByParams(array $params)
 * @method getLogByParams(array $params)
 * @method getItemLogByParams(array $params)
 * @method getUpdateByInfosByParams(array $params)
 */
class PurchaseOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $orderNo 采购单号 [ require false ]
     * @support  string $advanceNo 预付款单号 [ require false ]
     * @support  string $dueNo 应付款单号 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  string $finishStatus 完结状态 [ require false ]
     * @support  int $updateBy 更新人 [ require false ]
     * @support  string $createdAtStart 创建开始时间 [ require false ]
     * @support  string $createdAtEnd 创建结束时间 [ require false ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  string $demandNo 需求单号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @support  int $orderId 采购单id [ require false ]
     * @support  string $orderNo 采购单no [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 明细列表
     *
     * @support  int $orderId 采购单id [ require true ]
     * @support  string $sortBy 排序字段 [ require false ]
     * @support  string $sortType 排序类型 asc升 desc降 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $orderId 采购单id [ require true ]
     * @param  int $supplierId 供应商id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $orderId, int $supplierId) {
        return self::getClass()->update([
            "orderId" => $orderId,
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 提交(生成发货通知单)
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $orderId) {
        return self::getClass()->submit([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $orderId 采购单id [ require true ]
     * @param  array $orderItemIds 采购单明细ids [ require true ]
     * @param  int $closeCount 关闭数量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $orderId, array $orderItemIds, int $closeCount) {
        return self::getClass()->close([
            "orderId" => $orderId,
            "orderItemIds" => $orderItemIds,
            "closeCount" => $closeCount,
        ]);
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [ require true ]
     * @support  string $action 操作类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [ require true ]
     * @support  string $action 操作类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getItemLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取更新人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUpdateByInfos () {
        return self::getClass()->getUpdateByInfos();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}