<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplySystemSkuListPageByParams(array $params)
 */
class SupplerMaterial {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 供应商物料
     *
     * @support  array $fiele 查询字段 [ require false ]
     * @support  int $source 类型 [ require false ]
     * @support  string $skuCode skucode [ require false ]
     * @support  int $skuId skuId [ require false ]
     * @support  array $materialIds 物料id [ require false ]
     * @support  int $page 当前页码 [ require false ]
     * @support  int $pageSize 页面长度 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplySystemSkuListPage () {
        return self::getClass()->getSupplySystemSkuListPage([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier\SupplerMaterial');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier\SupplerMaterial');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}