<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method operationByParams(array $params)
 * @method batchOperationByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getSkuByListByParams(array $params)
 * @method getStockSkuByNameByParams(array $params)
 */
class PurchaseCountLimit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 采购上限配置列表
     *
     * @support  int $skuId skuid [ require false ]
     * @support  int $storeId 仓库id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 操作采购上限配置
     *
     * @support  int $skuId skuid [ require true ]
     * @support  int $storeId 仓库id [ require true ]
     * @support  int $count 限制数量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function operation () {
        return self::getClass()->operation([
        ]);
    }

    /**
     * 批量操作
     *
     * @support  array $data data [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchOperation () {
        return self::getClass()->batchOperation([
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $data 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * 获取列表中的sku
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuByList () {
        return self::getClass()->getSkuByList();
    }

    /**
     * 通过skuName 获取采购限制数据
     *
     * @param  string $skuName skuName [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockSkuByName (string $skuName) {
        return self::getClass()->getStockSkuByName([
            "skuName" => $skuName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseCountLimit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseCountLimit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}