<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListTreeBySkuIdByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method bindProductByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method productStoreTypeByParams(array $params)
 * @method delProductTagByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getProductByStoreByParams(array $params)
 * @method getAllProductTagByParams(array $params)
 */
class ProductTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料标签列表(分页)
     *
     * @support  string $tagName 标签名（模糊查询 [ require false ]
     * @support  string $isShow 是否展示 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  int $productId 产品Id [ require false ]
     * @support  string $storeType 门店类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getInfo([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料标签列表
     *
     * @support  array $productTagIds 标签ids [ require false ]
     * @support  string $tagName 标签名（模糊查询 [ require false ]
     * @support  string $isShow 是否展示 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  int $created_by 创建人 [ require false ]
     * @support  string $updatedAtStart 创建人 [ require false ]
     * @support  string $updatedAtEnd 创建人 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 获取物料绑定的标签列表（带选中）
     *
     * @param  int $skuId skuId [ require true ]
     * @param  int $isAll 是否展示全部标签 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListTreeBySkuId (int $skuId, int $isAll = 0) {
        return self::getClass()->getListTreeBySkuId([
            "skuId" => $skuId,
            "isAll" => $isAll,
        ]);
    }

    /**
     * 创建物料标签
     *
     * @support  string $tagName 标签名 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  array $storeType 门店品牌 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑物料标签
     *
     * @param  int $productTagId 标签id [ require true ]
     * @support  string $tagName 标签名 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  string $isShow 是否展示 [ require false ]
     * @support  array $storeType 门店品牌 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $productTagId) {
        return self::getClass()->update([
            "productTagId" => $productTagId,
        ]);
    }

    /**
     * 标签绑定的产品
     *
     * @param  int $productTagId 标签id [ require true ]
     * @param  array $productIds 产品ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProduct (int $productTagId, array $productIds = []) {
        return self::getClass()->bindProduct([
            "productTagId" => $productTagId,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取全部产品
     *
     * @param  int $isExport 是否导出 [ require false ]
     * @throws  \Exception
     * @return  array[]
     */
    public static function getProductList (int $isExport = 0) {
        return self::getClass()->getProductList([
            "isExport" => $isExport,
        ]);
    }

    /**
     * 门店品牌枚举
     *
     * @throws  \Exception
     * @return  array
     */
    public static function productStoreType () {
        return self::getClass()->productStoreType();
    }

    /**
     * 删除门店品牌
     *
     * @param  int $productTagId 标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delProductTag (int $productTagId) {
        return self::getClass()->delProductTag([
            "productTagId" => $productTagId,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * 获取门店可用产品标签
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getProductByStore () {
        return self::getClass()->getProductByStore();
    }

    /**
     * 获取可用产品标签
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProductTag () {
        return self::getClass()->getAllProductTag();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ProductTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ProductTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}