<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method revokeByParams(array $params)
 * @method processByParams(array $params)
 */
class RetailInventoryMission {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 盘点任务列表
     *
     * @support  string $missionNo 任务单号 [ require false ]
     * @support  string $createStart 创建时间开始 [ require false ]
     * @support  string $createEnd 创建时间结束 [ require false ]
     * @support  string $inventoryStart 盘点日期开始 [ require false ]
     * @support  string $inventoryEnd 盘点日期结束 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点任务详情
     *
     * @param  int $missionId 任务ID [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $status 审核状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $missionId) {
        return self::getClass()->detail([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 新增盘点任务
     *
     * @support  string $inventoryStart 盘点日期开始 [ require false ]
     * @support  string $inventoryEnd 盘点日期结束 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @support  int $allSku 是否所有商品 [ require false ]
     * @support  int $allStore 是否所有门店 [ require false ]
     * @param  array $storeIds 盘点门店ID数组 [ require false ]
     * @support  array $skuIds 盘点商品ID数组 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (array $storeIds = []) {
        return self::getClass()->create([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 盘点任务撤回
     *
     * @param  int $missionId 任务ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revoke (int $missionId) {
        return self::getClass()->revoke([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 盘点进度
     *
     * @support  int $missionId 任务ID [ require true ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $status 状态 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function process (int $page = 1, int $pageSize = 10) {
        return self::getClass()->process([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailInventoryMission');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailInventoryMission');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}