<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateByParams(array $params)
 * @method submitByParams(array $params)
 * @method createApproveByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method closeByParams(array $params)
 * @method updateOrderItemByParams(array $params)
 * @method updateCostPriceByParams(array $params)
 */
class RetailPurchaseOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $orderNo 采购单号 [ require false ]
     * @support  string $createdAtStart 创建开始时间 [ require false ]
     * @support  string $createdAtEnd 创建结束时间 [ require false ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  int $source 来源2成品3原料 [ require false ]
     * @support  string $demandNo 需求单号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @support  int $orderId 采购单id [ require false ]
     * @support  string $orderNo 采购单no [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $orderId 采购单id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $orderId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "orderId" => $orderId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $orderId 采购单id [ require true ]
     * @param  int $supplierId 供应商id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $orderId, int $supplierId) {
        return self::getClass()->update([
            "orderId" => $orderId,
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 提交(生成发货通知单)
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $orderId) {
        return self::getClass()->submit([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 发起审批
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createApprove (int $orderId) {
        return self::getClass()->createApprove([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 关闭
     *
     * @param  int $orderId 采购单id [ require true ]
     * @param  array $orderItemIds 采购单明细ids [ require true ]
     * @param  int $closeCount 关闭数量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $orderId, array $orderItemIds, int $closeCount) {
        return self::getClass()->close([
            "orderId" => $orderId,
            "orderItemIds" => $orderItemIds,
            "closeCount" => $closeCount,
        ]);
    }

    /**
     * 修改明细信息(预付款前)
     *
     * @param  array $data 修改的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateOrderItem (array $data) {
        return self::getClass()->updateOrderItem([
            "data" => $data,
        ]);
    }

    /**
     * 更新采购价(预付款后)
     *
     * @param  array $data 价格数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCostPrice (array $data) {
        return self::getClass()->updateCostPrice([
            "data" => $data,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailPurchaseOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailPurchaseOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}