<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bmsGetListByParams(array $params)
 * @method storeGetListByParams(array $params)
 * @method getListTagByParams(array $params)
 * @method getInfoFirstByParams(array $params)
 */
class ReceiveExceptionOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * BMS工单列表
     *
     * @support  string $receive_no 收货单号 [ require false ]
     * @support  int $sku_id skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $to_storage_id 收货方 [ require false ]
     * @support  int $from_storage_id 发货方 [ require false ]
     * @support  int $delivery_by 发货人 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bmsGetList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->bmsGetList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 门店工单列表
     *
     * @support  string $receive_no 收货单号 [ require false ]
     * @support  int $sku_id skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeGetList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->storeGetList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 工单状态栏
     *
     * @support  string $receive_no 收货单号 [ require false ]
     * @support  int $sku_id skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $to_storage_id 收货方 [ require false ]
     * @support  int $from_storage_id 发货方 [ require false ]
     * @support  int $delivery_by 发货人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListTag () {
        return self::getClass()->getListTag([
        ]);
    }

    /**
     * 工单详情
     *
     * @support  int $store_id 门店id [ require false ]
     * @param  int $id 工单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoFirst (int $id) {
        return self::getClass()->getInfoFirst([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}