<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUnitByParams(array $params)
 * @method syncUnitByParams(array $params)
 */
class Units {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单位s
     *
     * @param  string $name 名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUnit (string $name = '') {
        return self::getClass()->getUnit([
            "name" => $name,
        ]);
    }

    /**
     * 同步单位信息
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $nsId ns的id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncUnit (string $name, int $nsId = 0) {
        return self::getClass()->syncUnit([
            "name" => $name,
            "nsId" => $nsId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Units');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Units');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}