<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bmsGetListByParams(array $params)
 * @method getListTagByParams(array $params)
 * @method getInfoFirstByParams(array $params)
 * @method approveOrderByParams(array $params)
 * @method createExceptionOrderByParams(array $params)
 * @method storeGetListByParams(array $params)
 * @method storeRevokeByParams(array $params)
 * @method storeOperationOrderByParams(array $params)
 */
class ReceiveExceptionOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * BMS工单列表
     *
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $skuId skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $toStorageId 收货方 [ require false ]
     * @support  int $fromStorageId 发货方 [ require false ]
     * @support  int $deliveryBy 发货人 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bmsGetList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->bmsGetList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 工单状态栏
     *
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $skuId skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $toStorageId 收货方 [ require false ]
     * @support  int $fromStorageId 发货方 [ require false ]
     * @support  int $deliveryBy 发货人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListTag () {
        return self::getClass()->getListTag([
        ]);
    }

    /**
     * 工单详情
     *
     * @support  int $storeId 门店id [ require false ]
     * @param  int $id 工单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoFirst (int $id) {
        return self::getClass()->getInfoFirst([
            "id" => $id,
        ]);
    }

    /**
     * 审批工单
     *
     * @param  int $id 工单id [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $processType 操作类型 [ require false ]
     * @support  string $handleRemark 操作人备注 [ require false ]
     * @support  array $sendAddress 发货地址 [ require false ]
     * @support  array $receiveAddress 收货地址 [ require false ]
     * @support  int $toStorageId 收货仓库 [ require false ]
     * @support  int $fromStorageId 收货仓库 [ require false ]
     * @support  int $returnNum 退货数量 [ require false ]
     * @support  int $closureNum 关闭数量 [ require false ]
     * @support  int $reissueNum 补发数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function approveOrder (int $id) {
        return self::getClass()->approveOrder([
            "id" => $id,
        ]);
    }

    /**
     * 提交异常工单
     *
     * @support  int $receiveItemId 收货子单id [ require false ]
     * @support  array $images 异常图片 [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $storeRemark 门店描述 [ require false ]
     * @support  string $isApplyReissue 是否需要补发 [ require false ]
     * @support  int $applyReissueNum 补发数量 [ require false ]
     * @support  int $errorNum 异常数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function createExceptionOrder () {
        return self::getClass()->createExceptionOrder([
        ]);
    }

    /**
     * 门店工单列表
     *
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $skuId skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeGetList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->storeGetList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 门店撤销工单
     *
     * @support  int $id 工单id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeRevoke () {
        return self::getClass()->storeRevoke([
        ]);
    }

    /**
     * 门店操作工单
     *
     * @support  int $id 工单id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $processType 操作类型 [ require false ]
     * @support  int $operationBy 操作人 [ require false ]
     * @support  string $code 退回单号 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeOperationOrder () {
        return self::getClass()->storeOperationOrder([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}