<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method closeByParams(array $params)
 * @method getListByParams(array $params)
 * @method searchUnsaleByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method getStorageByParams(array $params)
 */
class PurchaseRetailUnsale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售领用单
     *
     * @support  int $applyId 申请人id [ require true ]
     * @support  int $applyDepartmentId 申请部门 [ require true ]
     * @support  string $reason 申请原因 [ require false ]
     * @support  int $source 1自用,2零售商品,3零售原料 [ require true ]
     * @support  int $fromStorageId 出仓库 [ require true ]
     * @support  string $name 姓名 [ require true ]
     * @support  string $mobile 手机号 [ require true ]
     * @support  string $province 省 [ require true ]
     * @support  string $city 市 [ require true ]
     * @support  string $district 区 [ require true ]
     * @support  string $address 地址 [ require true ]
     * @support  array $items 子单 [ require true ]
     * @support  mixed $item  [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 批量创建/导入零售单
     *
     * @support  array $data 创建领用单数据列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate([
        ]);
    }

    /**
     * 关闭创建零售领用单
     *
     * @support  int $unsaleId 领用单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function close () {
        return self::getClass()->close([
        ]);
    }

    /**
     * 分页查询
     *
     * @support  string $unsaleNo 领用单no [ require false ]
     * @support  string $createdAtBegin 查询开始时间 [ require false ]
     * @support  string $createdAtEnd 查询结束时间 [ require false ]
     * @support  int $applyId 领用人id [ require false ]
     * @support  int $applyDepartmentId 领用部门id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 零售领用主单查询
     *
     * @support  string $unsaleNo 领用单no [ require false ]
     * @support  string $createdAtBegin 查询开始时间 [ require false ]
     * @support  string $createdAtEnd 查询结束时间 [ require false ]
     * @support  int $applyId 领用人id [ require false ]
     * @support  int $applyDepartmentId 领用部门id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUnsale () {
        return self::getClass()->searchUnsale([
        ]);
    }

    /**
     * 获取单个主单详情
     *
     * @support  string $entryNo 入库单no [ require false ]
     * @support  int $storageId 仓库id [ require false ]
     * @support  string $createdAtStart 开始时间 [ require false ]
     * @support  string $createdAtEnd 终止时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetail () {
        return self::getClass()->getDetail([
        ]);
    }

    /**
     * 获取零售领用单关联仓库
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorage () {
        return self::getClass()->getStorage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseRetailUnsale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseRetailUnsale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}