<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateByParams(array $params)
 * @method revokeByParams(array $params)
 * @method submitByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method payByParams(array $params)
 * @method getLogByParams(array $params)
 */
class PurchaseDue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建应付账单
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $orderId) {
        return self::getClass()->create([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $dueNo 应付款单号 require false
     * @support  string $orderNo 采购单号 require false
     * @support  string $createdAtStart 创建开始时间 require false
     * @support  string $createdAtEnd 创建结束时间 require false
     * @support  int $createBy 创建人工号 require false
     * @support  string $approveStatus 审批状态 require false
     * @support  string $status 付款状态 require false
     * @support  int $supplierId 供应商id require false
     * @support  string $demandNo 需求单号 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $dueId 应付款单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $dueId) {
        return self::getClass()->detail([
            "dueId" => $dueId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $dueId 应付款单id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $dueId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "dueId" => $dueId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新
     *
     * @support  int $dueId 应付款单id [ require true ]
     * @support  int $supplierBankId 供应商账户id require false
     * @support  string $invoiceNumber 发票号 require false
     * @support  array $items 修改的子单数据 require false
     * @support  float $discount 优惠金额 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 撤销审批
     *
     * @param  int $dueId 应付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revoke (int $dueId) {
        return self::getClass()->revoke([
            "dueId" => $dueId,
        ]);
    }

    /**
     * 提交审批
     *
     * @param  int $dueId 应付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $dueId) {
        return self::getClass()->submit([
            "dueId" => $dueId,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 更新付款状态
     *
     * @param  string $type 单据类型 [ require true ]
     * @param  string $number 单号 [ require true ]
     * @param  int $status 付款状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pay (string $type, string $number, int $status) {
        return self::getClass()->pay([
            "type" => $type,
            "number" => $number,
            "status" => $status,
        ]);
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [ require true ]
     * @support  string $action 操作类型 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseDue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseDue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}