<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receiveShipByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method detailAllItemListByParams(array $params)
 * @method addReceiveLogisticByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class RetailAllocationReceive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售收货操作-收货
     *
     * @support  int $id 发货单id [ require true ]
     * @support  array $itemList 发货单sku列表 require false
     * @support  int $toStaffId 收货人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveShip () {
        return self::getClass()->receiveShip();
    }

    /**
     * 零售收货单列表
     *
     * @support  string $receiveNo 收货单号 require false
     * @support  int $fromStorageId 发货仓库id require false
     * @support  string $trackingNumber 物流单号 require false
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 require false
     * @support  string $skuName sku名称 require false
     * @support  string $skuCode sku编码 require false
     * @support  string $barcode 条形码 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 零售收货单详情
     *
     * @param  int $id 发货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 收货单单详情页商品搜索-分页
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * 收货单单详情页商品搜索-不分页
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @throws  \Exception
     * @return  array
     */
    public static function detailAllItemList () {
        return self::getClass()->detailAllItemList();
    }

    /**
     * 添加物流单号
     *
     * @support  array $items 收货单列表 [ require true ]
     * @support  mixed $item  require false
     * @throws  \Exception
     * @return  bool
     */
    public static function addReceiveLogistic () {
        return self::getClass()->addReceiveLogistic();
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\RetailAllocationReceive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\RetailAllocationReceive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}