<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method bindProductByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method productStoreTypeByParams(array $params)
 */
class ProductTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料标签列表
     *
     * @support  string $tagName 标签名（模糊查询 require false
     * @support  string $isShow 是否展示 require false
     * @support  string $type 标签类型 require false
     * @support  int $productId 产品Id require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getInfo([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 创建物料标签
     *
     * @support  string $tagName 标签名 require false
     * @support  string $type 标签类型 require false
     * @support  array $storeType 门店品牌 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑物料标签
     *
     * @support  int $productTagId 标签id require false
     * @support  string $tagName 标签名 require false
     * @support  string $type 标签类型 require false
     * @support  string $isShow 是否展示 require false
     * @support  array $storeType 门店品牌 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 标签绑定的产品
     *
     * @support  int $productTagId 标签id require false
     * @support  array $productIds 产品ids require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProduct () {
        return self::getClass()->bindProduct();
    }

    /**
     * 获取全部产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList () {
        return self::getClass()->getProductList();
    }

    /**
     * 门店品牌枚举
     *
     * @throws  \Exception
     * @return  string[]
     */
    public static function productStoreType () {
        return self::getClass()->productStoreType();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ProductTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ProductTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}