<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplyChainStaffsByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkusByMaterialIdByParams(array $params)
 * @method shelveByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method disableSkuByParams(array $params)
 * @method enableSkuByParams(array $params)
 * @method batchShelveByParams(array $params)
 * @method batchUnshelveByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method approveByParams(array $params)
 * @method revokeByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method getMaterialSkusByParams(array $params)
 * @method getMaterialListByParams(array $params)
 * @method storeGetMaterialByParams(array $params)
 * @method getMaterialByParams(array $params)
 * @method getMaterialsByNameByParams(array $params)
 * @method doAutoSetNoByParams(array $params)
 * @method autoSetNoByParams(array $params)
 * @method autoSetSkuCodeByParams(array $params)
 * @method getMaterialByNameByParams(array $params)
 * @method bmsExportAddByParams(array $params)
 * @method storeExportAddByParams(array $params)
 * @method bmsAllocationBatchExportAddByParams(array $params)
 * @method syncMaterialSkuByParams(array $params)
 * @method getAllSelfMaterialByParams(array $params)
 * @method getSkusByMaterialIdsByParams(array $params)
 * @method searchMaterialByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取采购员列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyChainStaffs () {
        return self::getClass()->getSupplyChainStaffs();
    }

    /**
     * 创建物料
     *
     * @support  string $name 名称 require false
     * @support  int $categoryId 分类id require false
     * @support  array $storeTypes 门店类型 require false
     * @support  int $brandId 品牌id require false
     * @support  string $deliveryType 发货方式 require false
     * @support  int $isStockTaking 是否盘点 require false
     * @support  int $isFixedAsset 是否资产 require false
     * @support  int $fixedAssetType 资产类型 require false
     * @support  array $skus sku信息 require false
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新物料
     *
     * @param  int $id 物料id [ require true ]
     * @support  string $name 名称 require false
     * @support  int $categoryId 分类id require false
     * @support  array $storeType 门店类型 require false
     * @support  int $brandId 品牌id require false
     * @support  string $deliveryType 发货方式 require false
     * @support  int $isStockTaking 是否盘点 require false
     * @support  int $isFixedAsset 是否资产 require false
     * @support  int $fixedAssetType 资产类型 require false
     * @support  array $skus sku信息 require false
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $name 名称 require false
     * @support  string $skuCode sku_code require false
     * @support  int $categoryId 分类id require false
     * @support  array $storeTypes 门店类型 require false
     * @support  int $supplierId 供应商id require false
     * @support  int $source 来源:1自用物料2零售商品3零售物料 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @support  int $status 0全部 1上架 require false
     * @support  int $buyerId 采购员Id require false
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据物料id获取sku信息
     *
     * @param  int $materialId 物料id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByMaterialId (int $materialId) {
        return self::getClass()->getSkusByMaterialId([
            "materialId" => $materialId,
        ]);
    }

    /**
     * 上架物料
     *
     * @param  int $id 物料id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function shelve (int $id) {
        return self::getClass()->shelve([
            "id" => $id,
        ]);
    }

    /**
     * 下架物料(暂未使用)
     *
     * @param  int $id 物料id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelve (int $id) {
        return self::getClass()->unshelve([
            "id" => $id,
        ]);
    }

    /**
     * 下架sku
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disableSku (int $skuId) {
        return self::getClass()->disableSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 恢复sku
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enableSku (int $skuId) {
        return self::getClass()->enableSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 批量上架物料
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchShelve (array $ids) {
        return self::getClass()->batchShelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架物料
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUnshelve (array $ids) {
        return self::getClass()->batchUnshelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量修改物料信息
     *
     * @param  array $data 物料信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 发起审批
     *
     * @param  int $skuId skuid [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function approve (int $skuId) {
        return self::getClass()->approve([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 撤销
     *
     * @param  string $processInstanceId sku的审批id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revoke (string $processInstanceId) {
        return self::getClass()->revoke([
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * getMaterialSkus
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkus () {
        return self::getClass()->getMaterialSkus();
    }

    /**
     * 获取物料列表(根据门店属性查询)集采使用
     *
     * @support  array $categoryIds 分类id数组 require false
     * @support  string $name 物料名称 require false
     * @support  string $storeType 门店类型 require false
     * @support  string $deliveryType 发货类型 require false
     * @support  int $supplierId 供应商id require false
     * @support  string $status sku状态 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @support  bool $isAll 是否不校验上下架状态 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getMaterialList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料列表(门店采购商城)
     *
     * @support  array $categoryIds 分类id数组 require false
     * @support  string $name 物料名称 require false
     * @support  int $productTagId 标签id require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeGetMaterial (int $page = 1, int $pageSize = 10) {
        return self::getClass()->storeGetMaterial([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getMaterial
     *
     * @param  string $code 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterial (string $code) {
        return self::getClass()->getMaterial([
            "code" => $code,
        ]);
    }

    /**
     * getMaterialsByName
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  int $isFixedAsset 是否固定资产,1是0否无全部 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialsByName (string $name, int $isFixedAsset = null) {
        return self::getClass()->getMaterialsByName([
            "name" => $name,
            "isFixedAsset" => $isFixedAsset,
        ]);
    }

    /**
     * 手动初始化每日单号
     *
     * @param  string $date 年月日：20210411 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function doAutoSetNo (string $date) {
        return self::getClass()->doAutoSetNo([
            "date" => $date,
        ]);
    }

    /**
     * 自动初始化物料code
     *
     * @throws  \Exception
     * @return  void
     */
    public static function autoSetNo () {
        return self::getClass()->autoSetNo();
    }

    /**
     * 自动初始化skucode
     *
     * @throws  \Exception
     * @return  void
     */
    public static function autoSetSkuCode () {
        return self::getClass()->autoSetSkuCode();
    }

    /**
     * 下拉远程搜索使用
     *
     * @param  string $name 物料名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialByName (string $name) {
        return self::getClass()->getMaterialByName([
            "name" => $name,
        ]);
    }

    /**
     * 根据source获取自用物料或者零售商品-创建导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function bmsExportAdd () {
        return self::getClass()->bmsExportAdd();
    }

    /**
     * 根据source获取自用物料或者零售商品-创建导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function storeExportAdd () {
        return self::getClass()->storeExportAdd();
    }

    /**
     * BMS-批量调拨模板下载
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function bmsAllocationBatchExportAdd () {
        return self::getClass()->bmsAllocationBatchExportAdd();
    }

    /**
     * 向ebs同步物料sku
     *
     * @param  array $materialIds 物料ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncMaterialSku (array $materialIds) {
        return self::getClass()->syncMaterialSku([
            "materialIds" => $materialIds,
        ]);
    }

    /**
     * 获取自用全部物料（包含下架）
     *
     * @param  int $isStockTaking 是否需要盘点,0无限制,1需要,2不需要 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @support  string $name 物料名称 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSelfMaterial (int $page = 1, int $pageSize = 10, int $isStockTaking = 0) {
        return self::getClass()->getAllSelfMaterial([
            "page" => $page,
            "pageSize" => $pageSize,
            "isStockTaking" => $isStockTaking,
        ]);
    }

    /**
     * 根据物料ids获取sku信息
     *
     * @param  array $materialIds 物料ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByMaterialIds (array $materialIds) {
        return self::getClass()->getSkusByMaterialIds([
            "materialIds" => $materialIds,
        ]);
    }

    /**
     * 查询物料sku信息
     *
     * @support  array $skuIds skuids require false
     * @support  int $source 来源 require false
     * @support  array $sources 来源s require false
     * @support  string $skuCodes skucode require false
     * @support  string $codeOrName code或者name require false
     * @support  string $status 物料状态 require false
     * @throws  \Exception
     * @return  array
     */
    public static function searchMaterial () {
        return self::getClass()->searchMaterial();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}