<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method closeByParams(array $params)
 * @method closeItemsByParams(array $params)
 * @method importTemplateByParams(array $params)
 * @method receiveByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 */
class RetailReceive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $receiveNo 收货单号 require false
     * @support  string $createdAtStart 创建开始时间 require false
     * @support  string $createdAtEnd 创建结束时间 require false
     * @support  int $toStorageId 收货方id require false
     * @support  int $createBy 创建人工号 require false
     * @support  int $status 状态 require false
     * @support  string $demandNo 需求单号 require false
     * @support  string $orderNo 采购单号 require false
     * @support  int $toStorageId 收货方id require false
     * @support  array $materialIds 物料id require false
     * @support  int $fromStorageId 发货方id require false
     * @support  string $noticeNo 发货通知单号 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页记录数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 详情
     *
     * @param  int $receiveId 收货单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $receiveId) {
        return self::getClass()->detail([
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $receiveId 收货单id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $receiveId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "receiveId" => $receiveId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 关闭
     *
     * @param  array $receiveIds 收货单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (array $receiveIds) {
        return self::getClass()->close([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 关闭收货单子单
     *
     * @param  int $receiveId 收货单id [ require true ]
     * @support  array $items 收货单items列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeItems (int $receiveId) {
        return self::getClass()->closeItems([
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 收货单导入模板
     *
     * @param  array $receiveIds 收货单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTemplate (array $receiveIds) {
        return self::getClass()->importTemplate([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 批量收货
     *
     * @param  array $data 收货单信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receive (array $data) {
        return self::getClass()->receive([
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailReceive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailReceive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}