<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bmsExportAddByParams(array $params)
 * @method storeExportAddByParams(array $params)
 * @method getStockByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据source获取自用物料或者零售商品-创建导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function bmsExportAdd () {
        return self::getClass()->bmsExportAdd();
    }

    /**
     * 根据source获取自用物料或者零售商品-创建导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function storeExportAdd () {
        return self::getClass()->storeExportAdd();
    }

    /**
     * 获取库存信息，可选条件仓库和skuids
     *
     * @support  int $storageId 仓库ID [ require true ]
     * @support  int $source 物料来源 [ require true ]
     * @support  array $skuids skuids require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStock () {
        return self::getClass()->getStock();
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}