<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 */
class PurchaseReturn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退货单
     *
     * @support  int $fromStorageId 退货方仓库id [ require true ]
     * @support  int $supplierId 退货方的收货方仓库id [ require true ]
     * @support  int $noticeId 发货通知单id require false
     * @support  int $orderId 采购订单id require false
     * @support  array $items 退货单明细 require false
     * @support  int $createRefund 是否自动创建退款单默认0 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取退货单子单(退货单详情)
     *
     * @support  int $returnId 退货单id require false
     * @support  string $returnNo 退货单No require false
     * @throws  \Exception
     * @return  array
     */
    public static function getDetail () {
        return self::getClass()->getDetail();
    }

    /**
     * 获取退货单分页
     *
     * @support  string $returnNo 退货单id require false
     * @support  int $createdBy 创建人 require false
     * @support  string $status 状态 require false
     * @support  int $supplierId 供应商id require false
     * @support  int $fromStorageId 退货方仓库 require false
     * @support  array $statuses 状态列表 require false
     * @support  int $noticeId 发货通知单ID require false
     * @support  string $noticeNo 发货通知单NO require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页记录数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination();
    }

    /**
     * 退货单列表不分页
     *
     * @support  string $returnNo 退货单id require false
     * @support  int $createdBy 创建人 require false
     * @support  string $status 状态 require false
     * @support  int $supplierId 供应商id require false
     * @support  int $fromStorageId 退货方仓库 require false
     * @support  int $toStorageId 收货方仓库 require false
     * @support  array $statuses 状态列表 require false
     * @support  int $noticeId 发货通知单ID require false
     * @support  string $noticeNo 发货通知单NO require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页记录数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseReturn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseReturn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}