<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 */
class SelfAllocationReceive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售收货单详情
     *
     * @param  int $id 发货单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 收货单单详情页商品搜索
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\SelfAllocationReceive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\SelfAllocationReceive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}