<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateByListByParams(array $params)
 * @method listByParams(array $params)
 * @method listByMaterialIdByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class MessageLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新人列表
     *
     * @param  string $type 修改类型 [ require true ]
     * @param  string $action 操作类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateByList (string $type = '', string $action = '') {
        return self::getClass()->updateByList([
            "type" => $type,
            "action" => $action,
        ]);
    }

    /**
     * 价格变动日志列表
     *
     * @support  string $name 物料名称 require false
     * @support  string $code 编码 require false
     * @support  int $supplierId 供应商id require false
     * @support  string $action 类型 require false
     * @support  string $type 修改类型 require false
     * @support  string $approveStatus 审批状态 require false
     * @support  int $staffId 更新人工号 require false
     * @support  string $createdAtStart 开始时间 require false
     * @support  string $createdAtEnd 结束时间 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据物料查询日志信息
     *
     * @param  int $materialId 物料id [ require true ]
     * @param  string $action 操作类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listByMaterialId (int $materialId, string $action = '') {
        return self::getClass()->listByMaterialId([
            "materialId" => $materialId,
            "action" => $action,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'MessageLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'MessageLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}