<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updatePurchaseRefundByParams(array $params)
 * @method submitPurchaseRefundByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 */
class PurchaseRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退款单
     *
     * @support  int $noticeId 应付款单号 require false
     * @support  int $orderId 采购单号 require false
     * @support  int $advanceId 预付款单id require false
     * @support  int $returnId 退货单id require false
     * @support  int $supplierId 供应商id [ require true ]
     * @support  int $createdBy 创建人 require false
     * @support  array $items 子单 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新退款单
     *
     * @support  int $refundId 退款单id [ require true ]
     * @support  int $updatedBy 操作人id [ require true ]
     * @support  array $items 操作人id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updatePurchaseRefund () {
        return self::getClass()->updatePurchaseRefund();
    }

    /**
     * 退款单提交/完成
     *
     * @support  int $refundId 退款单id [ require true ]
     * @support  int $updatedBy 操作人id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submitPurchaseRefund () {
        return self::getClass()->submitPurchaseRefund();
    }

    /**
     * 获取退货单子单
     *
     * @support  int $refundId 退货单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems();
    }

    /**
     * 分页查询退款单列表
     *
     * @support  string $refundNo 退款单no require false
     * @support  int $supplyId 供应商id require false
     * @support  int $orderId 采购单id require false
     * @support  string $returnNo 退货单no require false
     * @support  string $orderNo 采购带no require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination();
    }

    /**
     * 退货单列表不分页
     *
     * @support  string $refundNo 退款单no require false
     * @support  int $supplyId 供应商id require false
     * @support  int $orderId 采购单id require false
     * @support  string $returnNo 退货单no require false
     * @support  string $orderNo 采购带no require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}