<?php
namespace Mainto\Bridge\Enums\ProjectSupplyChain\Allocation;

class AllocationTypeEnum {
    /**
     * 店间调拨
     */
    const BETWEEN_STORE = 'between_store';
    /**
     * 退回总仓
     */
    const RETURN_MAIN = 'return_main';
    /**
     * 退回供应商仓
     */
    const RETURN_SUPPLIER = 'return_supplier';
    /**
     * 单据类型-由总仓发
     */
    const FROM_MAIN = 'from_main';
    /**
     * 单据类型-由供应商仓发
     */
    const FROM_SUPPLIER = 'from_supplier';
    /**
     * BMS-自用-总部调拨允许查询的调拨类型
     */
    const BMS_SELF_MAIN_ALLOCATION_TYPE = [0 => 'from_main',1 => 'from_supplier'];
    /**
     * BMS-自用-店间调拨允许查询的调拨类型
     */
    const BMS_SELF_STORE_ALLOCATION_TYPE = [0 => 'between_store',1 => 'return_main'];
    /**
     * BMS-零售-总部调拨允许查询的调拨类型
     */
    const BMS_RETAIL_MAIN_ALLOCATION_TYPE = [0 => 'from_main',1 => 'from_supplier'];
    /**
     * BMS-零售-店间调拨允许查询的调拨类型
     */
    const BMS_RETAIL_STORE_ALLOCATION_TYPE = [0 => 'between_store',1 => 'return_main'];
    /**
     * 所有调拨单单据类型
     */
    const ALLOCATION_TYPE_ALL = [0 => 'between_store',1 => 'return_main',2 => 'return_supplier',3 => 'from_main',4 => 'from_supplier'];
}