<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method waitDeliverNumberByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method detailAllItemListByParams(array $params)
 * @method checkCreateDataByParams(array $params)
 * @method createByParams(array $params)
 * @method searchProductByParams(array $params)
 * @method shipByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class RetailAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售-待处理调拨单数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function waitDeliverNumber () {
        return self::getClass()->waitDeliverNumber();
    }

    /**
     * 零售-调拨单列表
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 require false
     * @support  string $allocationType 单据类型 require false
     * @support  int $toStorageId 收货仓库id require false
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 require false
     * @support  string $skuName sku名称 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调拨单详情页商品搜索
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * 调拨单详情页商品搜索-全量不分页
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @throws  \Exception
     * @return  array
     */
    public static function detailAllItemList () {
        return self::getClass()->detailAllItemList();
    }

    /**
     * 新增调拨并创建发货单-数据检查
     *
     * @param  int $toStorageId 收货门店仓库id [ require true ]
     * @param  array $itemList 调拨单sku列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkCreateData (int $toStorageId, array $itemList) {
        return self::getClass()->checkCreateData([
            "toStorageId" => $toStorageId,
            "itemList" => $itemList,
        ]);
    }

    /**
     * 新增调拨并创建发货单
     *
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  array $itemList 调拨单sku列表 require false
     * @support  string $remark 备注 require false
     * @support  int $fromStaffId 发货人id [ require true ]
     * @support  array $trackingNumbers 物流单号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 搜索商品-库存表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchProduct (string $keyword) {
        return self::getClass()->searchProduct([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 require false
     * @support  string $remark 备注 require false
     * @support  array $trackingNumbers 物流单号 require false
     * @support  int $fromStaffId 发货人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function ship () {
        return self::getClass()->ship();
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\RetailAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\RetailAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}