<?php
namespace Mainto\Bridge\Enums\ProjectSupplyChain\Allocation;

class ImportCheckFieldEnum {
    /**
     * skuId在物料表不存在
     */
    const SKU_ID_NOT_EXIST_IN_MATERIAL_SKUS = 'sku_id_not_exist_in_material_skus';
    /**
     * skuId在库存表不存在
     */
    const SKU_ID_NOT_EXIST_IN_STOCKS = 'sku_id_not_exist_in_stocks';
    /**
     * 发货仓库id不存在
     */
    const FROM_STORAGE_ID_NOT_EXIST = 'from_storage_id_not_exist';
    /**
     * 发货仓库不能是总仓
     */
    const FROM_STORAGE_ID_CAN_NOT_BE_MAIN = 'from_storage_id_can_not_be_main';
    /**
     * 发货仓库不能是门店仓
     */
    const FROM_STORAGE_ID_CAN_NOT_BE_STORE = 'from_storage_id_can_not_be_store';
    /**
     * 收货仓库id不存在
     */
    const TO_STORAGE_ID_NOT_EXIST = 'to_storage_id_not_exist';
    /**
     * 收货仓库需为总仓
     */
    const TO_STORAGE_ID_MUST_BE_MAIN = 'to_storage_id_must_be_main';
    /**
     * 收货仓库不能是门店仓
     */
    const TO_STORAGE_ID_CAN_NOT_BE_STORE = 'to_storage_id_can_not_be_store';
    /**
     * 仓库id不能相同
     */
    const STORAGE_ID_CAN_NOT_BE_SAME = 'storage_id_can_not_be_same';
    /**
     * 仓库库存不足或者没有该货物
     */
    const STOCK_IN_THIS_STORAGE_IS_NOT_ENOUGH = 'stock_in_this_storage_is_not_enough';
    /**
     * 发货数量超出计划数量
     */
    const SHIP_COUNT_EXCEEDS_PLAN_COUNT = 'ship_count_exceeds_plan_count';
    /**
     * 调拨单id不存在
     */
    const ALLOCATION_ID_NOT_EXIST = 'allocation_id_not_exist';
    /**
     * 调拨单子表id不存在
     */
    const ALLOCATION_ITEM_ID_NOT_EXIST = 'allocation_item_id_not_exist';
    /**
     * 收货地址不存在
     */
    const WMS_ALLOCATION_STORAGE_NO_ADDRESS = 'wms_allocation_storage_no_address';
    /**
     * 非门店不能同步
     */
    const WMS_ALLOCATION_NOT_STORE = 'wms_allocation_not_store';
    const SKU_ID = [0 => 'sku_id_not_exist_in_material_skus',1 => 'sku_id_not_exist_in_stocks'];
    const FROM_STORAGE_ID = [0 => 'from_storage_id_not_exist',1 => 'from_storage_id_can_not_be_main',2 => 'from_storage_id_can_not_be_store',3 => 'storage_id_can_not_be_same'];
    const TO_STORAGE_ID = [0 => 'to_storage_id_not_exist',1 => 'to_storage_id_must_be_main',2 => 'to_storage_id_can_not_be_store',3 => 'storage_id_can_not_be_same'];
    const STOCK_INFO = [0 => 'stock_in_this_storage_is_not_enough'];
}