<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplyChainStaffsByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method bomProductlistByParams(array $params)
 * @method detailByParams(array $params)
 * @method disableSkuByParams(array $params)
 * @method enableSkuByParams(array $params)
 * @method batchImportByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getBaseInfoBySkuNameByParams(array $params)
 * @method getSkusByNameByParams(array $params)
 * @method getMaterialsByNameByParams(array $params)
 * @method getMaterialByNameByParams(array $params)
 */
class RetailMaterial {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取采购员列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyChainStaffs () {
        return self::getClass()->getSupplyChainStaffs();
    }

    /**
     * 创建物料
     *
     * @support  string $name 名称 require false
     * @support  int $categoryId 分类id require false
     * @support  int $source 来源:1自用物料2零售商品3零售物料 require false
     * @support  array $skus sku信息 require false
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新物料
     *
     * @param  int $id 物料id [ require true ]
     * @support  string $name 名称 require false
     * @support  int $categoryId 分类id require false
     * @support  array $skus sku信息 require false
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $code 编码 require false
     * @support  string $name 名称 require false
     * @support  string $skuName sku名称 require false
     * @support  int $categoryId 分类id require false
     * @support  int $supplierId 供应商id require false
     * @support  int $source 来源:1自用物料2零售商品3零售物料 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取bom商品列表
     *
     * @support  string $name 名称 require false
     * @support  int $source 来源:1自用物料2零售商品3零售物料 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bomProductlist (int $page = 1, int $pageSize = 10) {
        return self::getClass()->bomProductlist([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 停用sku
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disableSku (int $skuId) {
        return self::getClass()->disableSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 恢复sku
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enableSku (int $skuId) {
        return self::getClass()->enableSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 批量导入物料信息
     *
     * @param  array $data 物料信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchImport (array $data) {
        return self::getClass()->batchImport([
            "data" => $data,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * bom创建选择sku使用
     *
     * @param  string $skuName sku名称 [ require true ]
     * @param  int $source 来源:1自用物料2零售商品3零售物料 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBaseInfoBySkuName (string $skuName, int $source = 3) {
        return self::getClass()->getBaseInfoBySkuName([
            "skuName" => $skuName,
            "source" => $source,
        ]);
    }

    /**
     * 根据物料名称获取对应的sku信息
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  int $source 来源:1自用物料2零售商品3零售物料 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByName (string $name, int $source = 3) {
        return self::getClass()->getSkusByName([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * 根据物料名称获取对应的信息(bom列表搜索条件)
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  int $source 来源:1自用物料2零售商品3零售物料 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialsByName (string $name, int $source = 3) {
        return self::getClass()->getMaterialsByName([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * getMaterialByName
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  array $source 物料来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialByName (string $name, array $source = [0 => 2,1 => 3]) {
        return self::getClass()->getMaterialByName([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailMaterial');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailMaterial');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}