<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMaterialListByParams(array $params)
 * @method getMaterialByParams(array $params)
 * @method createByParams(array $params)
 * @method getDemandListByParams(array $params)
 * @method detailByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getBomProductsByParams(array $params)
 */
class BmsMaterial {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料列表(根据门店属性查询)
     *
     * @support  array $categoryIds 分类id数组 [Original type array&lt;int&gt;] 
     * @support  string $name 物料名称 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialList (int $page, int $pageSize) {
        return self::getClass()->getMaterialList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料采买sku详情
     *
     * @support  string $code 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterial () {
        return self::getClass()->getMaterial();
    }

    /**
     * 创建需求单
     *
     * @param  array $demandInfo 需求单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (array $demandInfo) {
        return self::getClass()->create([
            "demandInfo" => $demandInfo,
        ]);
    }

    /**
     * 需求单列表
     *
     * @support  string $type 类型 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $status 单据状态 
     * @support  int $createBy 申请人工号 [Original type uint] 
     * @support  int $skuId 物料skuId [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 需求单详情
     *
     * @param  int $id 需求单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * bom商品列表(bom编码和名称的获取) 自用
     *
     * @support  string $skuCode 商品skucode 
     * @support  string $skuName 商品skuname 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBomProducts () {
        return self::getClass()->getBomProducts();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'BmsMaterial');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'BmsMaterial');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}