<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMaterialListByParams(array $params)
 * @method getMaterialByParams(array $params)
 * @method createByParams(array $params)
 */
class BmsMaterial {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料列表(根据门店属性查询)
     *
     * @support  array $categoryIds 分类id数组 [Original type array&lt;int&gt;] 
     * @support  string $name 物料名称 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialList (int $page, int $pageSize) {
        return self::getClass()->getMaterialList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料采买sku详情
     *
     * @support  string $code 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterial () {
        return self::getClass()->getMaterial();
    }

    /**
     * 创建需求单
     *
     * @param  array $demandInfo 需求单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (array $demandInfo) {
        return self::getClass()->create([
            "demandInfo" => $demandInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'BmsMaterial');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'BmsMaterial');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}