<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method batchDealByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method itemListByParams(array $params)
 */
class RetailPurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建需求单
     *
     * @param  int $source 单据类型:1物料2成品3原料 [Original type uint] [ require true ]
     * @param  int $toStorageId 收货方 [Original type uint] [ require true ]
     * @param  string $remark 下单原因 [ require true ]
     * @param  array $items 明细信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $source, int $toStorageId, array $items, string $remark = '') {
        return self::getClass()->create([
            "source" => $source,
            "toStorageId" => $toStorageId,
            "items" => $items,
            "remark" => $remark,
        ]);
    }

    /**
     * 需求单列表
     *
     * @support  int $source 单据类型:1物料2成品3原料4零售自用 [Original type uint] 
     * @support  string $demandNo 需求单号 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $status 单据状态 
     * @support  int $createBy 申请人工号 [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 需求单详情
     *
     * @param  int $id 需求单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 批量处理
     *
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDeal (array $demandItemIds) {
        return self::getClass()->batchDeal([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @param  string $closeReason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose (array $demandItemIds, string $closeReason) {
        return self::getClass()->batchClose([
            "demandItemIds" => $demandItemIds,
            "closeReason" => $closeReason,
        ]);
    }

    /**
     * 明细列表
     *
     * @support  string $demandNo 需求单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  array $materialIds 物料id 
     * @support  int $toStorageId 收货方id [Original type uint] 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @support  int $buyerId 采购员id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  array $status 状态 
     * @support  string $approveAtStart 审批通过开始时间 
     * @support  string $approveAtEnd 审批通过结束时间 
     * @support  string $type 采购类型 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailPurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailPurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}