<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method waitDeliverNumberByParams(array $params)
 * @method listByParams(array $params)
 * @method fromMainListByParams(array $params)
 * @method betweenStoreListByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method searchProductByParams(array $params)
 * @method closeAllocationItemByParams(array $params)
 * @method shipByParams(array $params)
 * @method exportBatchShipAddByParams(array $params)
 * @method allocationsRetryToEbsByParams(array $params)
 */
class RetailAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售-待处理调拨单数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function waitDeliverNumber () {
        return self::getClass()->waitDeliverNumber();
    }

    /**
     * 零售-调拨单列表
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 
     * @support  string $allocationType 单据类型 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @support  string $skuName sku名称 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 零售-调拨单列表-总部调拨
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 
     * @support  string $allocationType 单据类型:from_main, from_supplier 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @support  string $skuName sku名称 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function fromMainList () {
        return self::getClass()->fromMainList();
    }

    /**
     * 零售-调拨单列表-店间调拨
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 
     * @support  string $allocationType 单据类型: between_store,return_main 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @support  string $skuName sku名称 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function betweenStoreList () {
        return self::getClass()->betweenStoreList();
    }

    /**
     * 调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调拨单详情页商品搜索
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * 新增调拨
     *
     * @support  int $fromStorageId 收货仓库id [ require true ]
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  array $itemList 调拨单sku列表 
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 新增批量调拨
     * @deprecated
     *
     * @support  array $data 调拨单所有sku相关信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 搜索商品-物料表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchProduct (string $keyword) {
        return self::getClass()->searchProduct([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 调拨单详情-关闭调拨单
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeAllocationItem () {
        return self::getClass()->closeAllocationItem();
    }

    /**
     * 调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 
     * @support  string $remark 备注 
     * @support  array $trackingNumbers 物流单号 
     * @support  int $fromStaffId 发货人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function ship () {
        return self::getClass()->ship();
    }

    /**
     * 批量发货模板下载-导出查询结果
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function exportBatchShipAdd () {
        return self::getClass()->exportBatchShipAdd();
    }

    /**
     * 重试 推送ebs失败的调拨单
     *
     * @param  array $allocationNos 调拨单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allocationsRetryToEbs (array $allocationNos) {
        return self::getClass()->allocationsRetryToEbs([
            "allocationNos" => $allocationNos,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}