<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoragesByParams(array $params)
 * @method getStorageByStoreIdByParams(array $params)
 * @method storageListByParams(array $params)
 * @method createStorageByStoreByParams(array $params)
 * @method createStorageBySupplierByParams(array $params)
 */
class Storage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取仓库s
     *
     * @support  array $sources 类型:4供应商,123为仓库 
     * @support  string $name 名称 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorages () {
        return self::getClass()->getStorages();
    }

    /**
     * 根据门店获取对应仓库
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreId () {
        return self::getClass()->getStorageByStoreId();
    }

    /**
     * 获取仓库列表
     *
     * @support  array $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @support  string $name 仓库名称 
     * @throws  \Exception
     * @return  array
     */
    public static function storageList () {
        return self::getClass()->storageList();
    }

    /**
     * 创建门店仓库
     *
     * @param  int $id 门店id [ require true ]
     * @param  string $name 门店名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStorageByStore (int $id, string $name) {
        return self::getClass()->createStorageByStore([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 创建供应商仓库
     *
     * @param  int $id 供应商id [ require true ]
     * @param  string $name 供应商名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStorageBySupplier (int $id, string $name) {
        return self::getClass()->createStorageBySupplier([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Storage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Storage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}