<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSuppliersByParams(array $params)
 * @method syncSupplierByParams(array $params)
 * @method getBuyerSuppliersByParams(array $params)
 */
class Supplier {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取供应商s
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuppliers (string $name = '') {
        return self::getClass()->getSuppliers([
            "name" => $name,
        ]);
    }

    /**
     * 同步供应商信息
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $nsId ns的id [Original type uint] [ require true ]
     * @param  float $prepaidRate ns的id [Original type double] [ require true ]
     * @param  array $extend 额外信息 [ require true ]
     * @param  array $details 额外信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncSupplier (string $name, int $nsId = 0, float $prepaidRate = 0.0, array $extend = [], array $details = []) {
        return self::getClass()->syncSupplier([
            "name" => $name,
            "nsId" => $nsId,
            "prepaidRate" => $prepaidRate,
            "extend" => $extend,
            "details" => $details,
        ]);
    }

    /**
     * 获取采购员负责的供应商信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBuyerSuppliers () {
        return self::getClass()->getBuyerSuppliers();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}