<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getApproveByParams(array $params)
 * @method getLogByParams(array $params)
 * @method autoCreateNoByParams(array $params)
 * @method getCountByStoreIdByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取审批详情
     *
     * @param  string $processInstanceId 审批id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getApprove (string $processInstanceId) {
        return self::getClass()->getApprove([
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 获取日志信息
     *
     * @param  array $entities 日志标记 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLog (array $entities, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getLog([
            "entities" => $entities,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 自动初始化每日单号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoCreateNo () {
        return self::getClass()->autoCreateNo();
    }

    /**
     * 根据门店id和时间查询采购数据
     *
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCountByStoreId (int $storeId, string $startAt = '', string $endAt = '') {
        return self::getClass()->getCountByStoreId([
            "storeId" => $storeId,
            "startAt" => $startAt,
            "endAt" => $endAt,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}