<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplyChainStaffsByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method disableSkuByParams(array $params)
 * @method enableSkuByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class RetailMaterial {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取采购员列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyChainStaffs () {
        return self::getClass()->getSupplyChainStaffs();
    }

    /**
     * 创建物料
     *
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新物料
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $code 编码 
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除sku
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableSku (int $skuId) {
        return self::getClass()->disableSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 恢复sku
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableSku (int $skuId) {
        return self::getClass()->enableSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 批量修改物料信息
     *
     * @param  array $data 物料信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailMaterial');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailMaterial');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}