<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getDemandListByParams(array $params)
 * @method detailByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class RetailPurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建需求单
     *
     * @param  string $type 单据类型:原料,成品 [ require true ]
     * @param  int $toStorageId 收货方 [Original type uint] [ require true ]
     * @param  array $items 明细信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $type, int $toStorageId, array $items) {
        return self::getClass()->create([
            "type" => $type,
            "toStorageId" => $toStorageId,
            "items" => $items,
        ]);
    }

    /**
     * 修改需求单
     *
     * @param  int $id 需求单id [Original type uint] [ require true ]
     * @param  string $type 单据类型:原料,成品 [ require true ]
     * @param  int $toStorageId 收货方 [Original type uint] [ require true ]
     * @param  array $items 明细信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $type, int $toStorageId, array $items) {
        return self::getClass()->update([
            "id" => $id,
            "type" => $type,
            "toStorageId" => $toStorageId,
            "items" => $items,
        ]);
    }

    /**
     * 需求单列表
     *
     * @support  string $type 类型 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $status 单据状态 
     * @support  int $createBy 申请人工号 [Original type uint] 
     * @support  int $skuId 物料skuId [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 需求单详情
     *
     * @param  int $id 需求单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailPurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailPurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}