<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method itemListByParams(array $params)
 * @method importTemplateByParams(array $params)
 * @method importByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getItemLogByParams(array $params)
 */
class RetailPurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $noticeNo 发货通知单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  int $createBy 创建人工号 [Original type uint] 
     * @support  int $fromStorageId 发货方id [Original type uint] 
     * @support  array $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $noticeId 发货通知单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $noticeId) {
        return self::getClass()->detail([
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 零售采购的发货修改
     *
     * @param  int $noticeId 发货通知单id [Original type uint] [ require true ]
     * @param  string $planDate 预计到货时间 [ require true ]
     * @param  string $trackingNumber 物流单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $noticeId, string $planDate = '', string $trackingNumber = '') {
        return self::getClass()->update([
            "noticeId" => $noticeId,
            "planDate" => $planDate,
            "trackingNumber" => $trackingNumber,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $noticeId 发货通知单id [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $noticeId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "noticeId" => $noticeId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 发货通知单导入模板
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTemplate (array $noticeIds) {
        return self::getClass()->importTemplate([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 导入快递单号和数量
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function import (array $data) {
        return self::getClass()->import([
            "data" => $data,
        ]);
    }

    /**
     * 批量发运
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSend (array $noticeIds) {
        return self::getClass()->batchSend([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  array $data 待修改的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  array $data 待关闭的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose (array $data) {
        return self::getClass()->batchClose([
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [Original type uint] [ require true ]
     * @support  string $action 操作类型 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getItemLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailPurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailPurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}