<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method adjustDetailByParams(array $params)
 * @method approveByParams(array $params)
 * @method differenceByParams(array $params)
 */
class RetailInventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 盘点结果
     *
     * @support  string $inventoryStart 盘点日期开始 
     * @support  string $inventoryEnd 盘点日期结束 
     * @support  int $storeId 门店ID [Original type uint] 
     * @support  int $isDifferent 有无差异 [Original type uint] 
     * @support  string $approveStatus 审核状态 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点结果详情
     *
     * @param  int $inventoryId 盘点ID [Original type uint] [ require true ]
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->detail([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点调整明细
     *
     * @param  int $inventoryId 盘点ID [Original type uint] [ require true ]
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function adjustDetail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->adjustDetail([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点审批通过
     *
     * @param  array $inventoryIds 盘点IDs [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approve (array $inventoryIds) {
        return self::getClass()->approve([
            "inventoryIds" => $inventoryIds,
        ]);
    }

    /**
     * 盘点差异
     *
     * @support  string $approveStart 调整日期开始 
     * @support  string $approveEnd 调整日期结束 
     * @support  int $storeId 门店ID [Original type uint] 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function difference (int $page = 1, int $pageSize = 10) {
        return self::getClass()->difference([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailInventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailInventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}