<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method saveByParams(array $params)
 * @method addByParams(array $params)
 */
class RetailInventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 库存盘点
     *
     * @support  string $inventoryStart 盘点日期开始 
     * @support  string $inventoryEnd 盘点日期结束 
     * @support  string $inventoryType 盘点类型 
     * @support  string $approveStatus 审核状态 
     * @support  int $createBy 提交人 [Original type uint] 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点详情
     *
     * @param  int $inventoryId 盘点ID [Original type uint] [ require true ]
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->detail([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 保存盘点
     *
     * @support  int $inventoryId 盘点ID [Original type uint] [ require true ]
     * @support  array $skuInfos 盘点商品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save () {
        return self::getClass()->save();
    }

    /**
     * 新增盘点
     *
     * @support  array $skuInfos 盘点商品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\RetailInventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\RetailInventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}