<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method waitDeliverNumberByParams(array $params)
 * @method fromMainListByParams(array $params)
 * @method betweenStoreListByParams(array $params)
 * @method listByParams(array $params)
 * @method getAllocationCreateByListByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method detailAllItemListByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method searchMaterialByParams(array $params)
 * @method closeAllocationItemByParams(array $params)
 * @method shipByParams(array $params)
 * @method exportBatchShipAddByParams(array $params)
 * @method getNeedToShipDataByAllocationIdsByParams(array $params)
 * @method batchPushByParams(array $params)
 * @method closeAllocationByAllocationIdsByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class SelfAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自用-待处理调拨单数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function waitDeliverNumber () {
        return self::getClass()->waitDeliverNumber();
    }

    /**
     * 自用-调拨单列表-总部调拨
     * @deprecated
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 require false
     * @support  string $allocationType 单据类型:from_main, from_supplier require false
     * @support  int $toStorageId 收货仓库id require false
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 require false
     * @support  string $skuName sku名称 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function fromMainList () {
        return self::getClass()->fromMainList();
    }

    /**
     * 自用-调拨单列表-店间调拨
     * @deprecated
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 require false
     * @support  string $allocationType 单据类型: between_store,return_main require false
     * @support  int $toStorageId 收货仓库id require false
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 require false
     * @support  string $skuName sku名称 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function betweenStoreList () {
        return self::getClass()->betweenStoreList();
    }

    /**
     * 和零售有区别的点，这里的列表不用区分调拨单的创建方，其实是去掉了 createType 的筛选条件
     *
     * @support  string $allocationNo 调拨单号 require false
     * @support  string $allocationType 单据类型 require false
     * @support  string $createdAtStart 创建时间开始时间 require false
     * @support  string $createdAtEnd 创建时间结束时间 require false
     * @support  int $createBy 创建人 require false
     * @support  int $fromStorageId 发货仓库id require false
     * @support  int $toStorageId 收货仓库id require false
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 require false
     * @support  string $skuName sku名称 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取所有调拨单的创建人
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllocationCreateByList () {
        return self::getClass()->getAllocationCreateByList();
    }

    /**
     * 调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调拨单详情页商品搜索
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * 调拨单详情页商品搜索-全量不分页
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @throws  \Exception
     * @return  array
     */
    public static function detailAllItemList () {
        return self::getClass()->detailAllItemList();
    }

    /**
     * 新增调拨
     *
     * @support  int $fromStorageId 收货仓库id [ require true ]
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  array $itemList 调拨单sku列表 require false
     * @support  string $remark 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 新增批量调拨
     * @deprecated
     *
     * @support  array $data 调拨单所有sku相关信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 搜索物料-物料表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchMaterial (string $keyword) {
        return self::getClass()->searchMaterial([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 调拨单详情-关闭调拨单
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeAllocationItem () {
        return self::getClass()->closeAllocationItem();
    }

    /**
     * 调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 require false
     * @support  string $remark 备注 require false
     * @support  array $trackingNumbers 物流单号 require false
     * @support  int $fromStaffId 发货人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function ship () {
        return self::getClass()->ship();
    }

    /**
     * 批量发货模板下载-导出查询结果
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function exportBatchShipAdd () {
        return self::getClass()->exportBatchShipAdd();
    }

    /**
     * 通过调拨单id获取子表发货信息
     *
     * @param  array $allocationIds 调拨单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNeedToShipDataByAllocationIds (array $allocationIds) {
        return self::getClass()->getNeedToShipDataByAllocationIds([
            "allocationIds" => $allocationIds,
        ]);
    }

    /**
     * 批量推送调拨单到wms
     *
     * @param  array $allocationIds 调拨单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchPush (array $allocationIds) {
        return self::getClass()->batchPush([
            "allocationIds" => $allocationIds,
        ]);
    }

    /**
     * 通过调拨单id关闭调拨单
     *
     * @param  array $allocationIds 调拨单id [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeAllocationByAllocationIds (array $allocationIds, string $remark = '') {
        return self::getClass()->closeAllocationByAllocationIds([
            "allocationIds" => $allocationIds,
            "remark" => $remark,
        ]);
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\SelfAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\SelfAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}