<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receiveShipByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method addReceiveLogisticByParams(array $params)
 */
class RetailAllocationReceive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售收货操作-收货
     *
     * @support  int $id 发货单id [ require true ]
     * @support  array $itemList 发货单sku列表 
     * @support  int $toMemberId 收货人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveShip () {
        return self::getClass()->receiveShip();
    }

    /**
     * 零售收货单列表
     *
     * @support  string $receiveNo 收货单号 
     * @support  int $fromStorageId 发货仓库id 
     * @support  string $trackingNumber 物流单号 
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 
     * @support  string $skuName sku名称 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 零售收货单详情
     *
     * @param  int $id 发货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 收货单单详情页商品搜索
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * 添加物流单号
     *
     * @param  int $receiveId 发货单id [ require true ]
     * @param  array $trackingNumbers 物流单号数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addReceiveLogistic (int $receiveId, array $trackingNumbers) {
        return self::getClass()->addReceiveLogistic([
            "receiveId" => $receiveId,
            "trackingNumbers" => $trackingNumbers,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\RetailAllocationReceive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\RetailAllocationReceive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}